<?php
include 'dbcon.php';
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$column = array(' ', ' ', ' ', 't1.invoice_no', 't1.invoice_date', 't1.vendor_id');

$cus_id = mysqli_real_escape_string($con, $_REQUEST['cus_id']);
$invoice_no = mysqli_real_escape_string($con, $_REQUEST['invoice_no']);
$company_id = mysqli_real_escape_string($con, $_REQUEST['company_id']);
$purchase_type = mysqli_real_escape_string($con, $_REQUEST['purchase_type']);

$sdate = $_REQUEST['sdate'];
$edate = $_REQUEST['edate'];

$date_filter = 'str_to_date(t1.invoice_date, "%d-%m-%Y") BETWEEN str_to_date("' . $sdate . '", "%d-%m-%Y") AND str_to_date("' . $edate . '", "%d-%m-%Y")';

$cus_det       = (!empty($cus_id)) ? " AND t1.vendorid = '" . $cus_id . "' " : "";
$invoice_no    = (!empty($invoice_no)) ? " AND t1.invoice_no = '" . $invoice_no . "' " : "";
$company_id    = (!empty($company_id)) ? " AND t1.company_id = '" . $company_id . "' " : "";
$purchase_type = (!empty($purchase_type)) ? " AND t1.purchase_type = '" . $purchase_type . "' " : "";





$query_str = "SELECT t1.*,t2.companyname as vcompanyname,t3.companyname FROM ebill_gr AS t1 
              INNER JOIN vendordetails AS t2 ON t1.vendorid = t2.id 
              INNER JOIN company_details AS t3 ON t1.company_id = t3.id 
              WHERE " . $date_filter . " " . $cus_det . " " . $invoice_no . " " . $company_id . " " . $purchase_type . "";

// Ordering logic
if (isset($_POST['order']) && !empty($_POST['order'])) {
    $column_name = abs($_POST['order'][0]['column']);
    $order_type = strtoupper($_POST['order'][0]['dir']);
    if ($column_name > 2) {
        $query_str .= " ORDER BY " . $column[$column_name] . " " . $order_type . " ";
    } else {
        $query_str .= " ORDER BY str_to_date(t1.invoice_date, '%d-%m-%Y'), t1.invoice_no ASC ";
    }
} else {
    $query_str .= " ORDER BY str_to_date(t1.invoice_date, '%d-%m-%Y'), t1.invoice_no ASC ";
}

// Execute initial query to get total records without limit
$result = mysqli_query($con, $query_str);
if (!$result) {
    die("SQL Error: " . mysqli_error($con) . "\nQuery: " . $query_str);
}
$recordsTotal = mysqli_num_rows($result);

// Apply pagination if needed
if (isset($_POST["length"]) && $_POST["length"] != -1) {
    $query_str .= " LIMIT " . intval($_POST['start']) . ", " . intval($_POST['length']);
}

// Re-execute the query with LIMIT applied
$result = mysqli_query($con, $query_str);
if (!$result) {
    die("SQL Error with LIMIT: " . mysqli_error($con) . "\nQuery: " . $query_str);
}

$data = array();
$i = isset($_POST['start']) ? $_POST['start'] + 1 : 1;

while ($row = mysqli_fetch_assoc($result)) {
    $subdata = array();
    $id=$row['id'];	
    $vcompanyname=$row['vcompanyname'];
    $companyname=$row['companyname'];
    $invoice_no=$row['invoice_no'];
    $invoice_date=$row['invoice_date'];
    $total_amount=$row['total_amount'];
    $c_status=$row['c_status'];
    $purchase_type = $row['purchase_type'] == '1' ? 'Invoice' : 'Challan';

    $subdata[] = $i;
    $subdata[] = '<a href="edit_ebill_gr.php?id=' . $id . '">Edit</a>';
    $subdata[] = '<a href="#" id="' . $id . '" class="delbutton"> Delete </a>';
    $subdata[] = '<a href="print/purchase_gr_invoice.php?id=' . $id . '">Print</a>';
    $subdata[] = $purchase_type;
    $subdata[] = $vcompanyname;
    $subdata[] = $companyname;
    $subdata[] = $invoice_no;
    $subdata[] = $invoice_date;
    $subdata[] = $total_amount;

    $data[] = $subdata;
    $i++;
}

$json_data = array(
    'draw' => intval($_POST['draw']),
    'recordsTotal' => intval($recordsTotal),
    'recordsFiltered' => intval($recordsTotal),
    'data' => $data,
);

echo json_encode($json_data);
?>
